/*	Renegade Scripts.dll
	Example Plugin Code
	Copyright 2007 Whitedragon(MDB), Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/

/*  This is designed to serve as both an example on how to make a plugin and to give users the basic framework of a plugin.
    The plugin is simple: it creates an object creation hook and attaches the script "Plugin_Example_Script" to all objects.
	The script prints out a message whenever an object is created or destroyed.
	There are also examples of the new format for bhs.dll hooks.
*/

#include "scripts.h"
#include <stdarg.h>
#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif
#include "engine.h"
#include "gmmain.h"
#include "plugin.h"


int ObjectHookID = 0;
ObjectCreateHookStruct *ObjectHookStruct = 0;
ExampleSettingsStruct *ExampleSettings = 0;

void ExampleSettingsStruct::Load() 
{
	SettingsLoader::Load();
	LoadBool(EnableInfantryParachutes, "EnableInfantryParachutes");
}

void ObjectHookCall(void *data,GameObject *obj) 
{
	 if (Is_Vehicle(obj))
	 {
		if (!Is_DecorationPhys(obj) && (Get_Vehicle_Mode(obj) == FLYING))
		{
			Attach_Script_Once(obj, "Parachute","");
		}
	 }
	 else if (Commands->Is_A_Star(obj) && ( Is_Map_Flying() || ExampleSettings->EnableInfantryParachutes ))
	 {
		Attach_Script_Once(obj, "Parachute","");
	}
}


void Plugin_Load() 
{

	ExampleSettings = new ExampleSettingsStruct("automatic_parachutes.ini");
	ExampleSettings->Load();


	ObjectHookStruct = new ObjectCreateHookStruct;
	ObjectHookStruct->hook = ObjectHookCall;
	ObjectHookStruct->data = 0;
	ObjectHookID = AddObjectCreateHook(ObjectHookStruct);
}

void Plugin_Unload() {
}

void Parachute::Created(GameObject *obj)
{
	isFalling = false;
	floaterID = 0;
	pchuteID = 0;
	fallin = 0;
	InVehicle = false;
	isRunning = false;
	health = Commands->Get_Health(obj);
	if (ExampleSettings->EnableInfantryParachutes)
	{
		Commands->Start_Timer(obj, this, 1.0f, 3);
	}
}

void Parachute::Damaged(GameObject *obj,GameObject *damager,float damage)
{
	if (!damager && isFalling && (damage < 1000))
	{
		Commands->Set_Health(obj,health);
		isFalling = false;
	}
	else
	{
		health = Commands->Get_Health(obj);
	}
}

void Parachute::Killed(GameObject *obj, GameObject *shooter)
{
	if (Is_Vehicle(obj))
	{
		if (Commands->Get_ID(obj) && obj && As_VehicleGameObj(obj))
		{
			VectorClass<GameObject *> *ptr = (VectorClass<GameObject *>*)(obj+0x9AC);
			VectorClass<GameObject *> occupants = (VectorClass<GameObject *>)*ptr;
			int x = occupants.Length();
			for (int i = 0;i < x;i++)
			{
				if (occupants[i])
				{
					Commands->Send_Custom_Event(occupants[i],occupants[i],4612,0,0);
				}
			}
		}
	}
	else if (Is_Soldier(obj))
	{
		Commands->Enable_Collisions(obj);
		if (Commands->Find_Object(pchuteID))
		{
			Commands->Destroy_Object(Commands->Find_Object(pchuteID));
			pchuteID = 0;
		}
		if (Commands->Find_Object(floaterID))
		{
			Commands->Destroy_Object(Commands->Find_Object(floaterID));
			floaterID = 0;
		}
		isFalling = false;
		InVehicle = false;
	}
}

void Parachute::Timer_Expired(GameObject *obj,int number)
{
	if (number == 1 && !InVehicle && !Is_Vehicle(obj) && !isRunning)
	{
		isRunning = true;
		newpos = Commands->Get_Position(obj);
		if (newpos.Z < pos.Z)
		{
			fallin += pos.Z - newpos.Z;
			if (fallin > 3 && !isFalling)
			{
				isFalling = true;
				GameObject *floater = Commands->Create_Object("CtfFlag",Commands->Get_Position(obj));
				Commands->Set_Model(floater,"null");
				Commands->Set_Facing(floater,Commands->Get_Facing(obj));
				GameObject *pchute = Commands->Create_Object("CtfFlag",Commands->Get_Position(obj)); 
				Commands->Set_Model(pchute,"X5D_Parachute");
				Commands->Disable_All_Collisions(pchute);
				Commands->Disable_Physical_Collisions(obj);
				Commands->Attach_To_Object_Bone(obj,floater,"");
				Commands->Attach_To_Object_Bone(pchute,obj,"");
				floaterID = Commands->Get_ID(floater);
				pchuteID = Commands->Get_ID(pchute);
			}
			pos = Commands->Get_Position(obj);
			Commands->Start_Timer(obj, this, 0.1f, 1);
		}
		else 
		{
			if (!Get_Vehicle(obj))
			{
				Commands->Enable_Collisions(obj);
			}
			if (Commands->Find_Object(pchuteID))
			{
				Commands->Destroy_Object(Commands->Find_Object(pchuteID));
				pchuteID = 0;
			}
			if (Commands->Find_Object(floaterID))
			{
				Commands->Destroy_Object(Commands->Find_Object(floaterID));
				floaterID = 0;
			}
			Commands->Start_Timer(obj, this, 2.0f, 2);
		}
		isRunning = false;
	}
	else if (number == 2)
	{
		//Console_Input("msg called"); // DEBUG CRAP
		isFalling = false;

		if (!Get_Vehicle(obj))
		{
			Commands->Enable_Collisions(obj);
		}
		if (Commands->Find_Object(pchuteID))
		{
			Commands->Destroy_Object(Commands->Find_Object(pchuteID));
			pchuteID = 0;
		}
		if (Commands->Find_Object(floaterID))
		{
			Commands->Destroy_Object(Commands->Find_Object(floaterID));
			floaterID = 0;
		}
	}
	else if (number == 3) // DEBUG CRAP
	{
		if (!isFalling && !isRunning)
		{
			health = Commands->Get_Health(obj);
			fallin = 0;
			pos = Commands->Get_Position(obj);
			Commands->Start_Timer(obj, this, 0.5f, 1);
		}
		Commands->Start_Timer(obj, this, 1.0f, 3);
	}
}

void Parachute::Custom(GameObject *obj, int message, int param, GameObject *sender) 
{
	//DLOG;
	if (message == CUSTOM_EVENT_VEHICLE_EXIT)
	{
		Commands->Send_Custom_Event(sender,sender,4612,0,0);		
	}
	else if (message == CUSTOM_EVENT_VEHICLE_ENTER)
	{
		Commands->Send_Custom_Event(sender,sender,4613,0,0);		
	}
	else if (message == 4612)
	{
		InVehicle = false;
		health = Commands->Get_Health(obj);
		fallin = 0;
		pos = Commands->Get_Position(obj);
		Commands->Start_Timer(obj, this, 0.1f, 1);
	}
	else if (message == 4613)
	{
		InVehicle = true;
		isFalling = false;
		if (Commands->Find_Object(pchuteID))
		{
			Commands->Destroy_Object(Commands->Find_Object(pchuteID));
			pchuteID = 0;
		}
		if (Commands->Find_Object(floaterID))
		{
			Commands->Destroy_Object(Commands->Find_Object(floaterID));
			floaterID = 0;
		}
	}
}

ScriptRegistrant<Parachute> ParachuteRegistrant("Parachute","");

